package gov.va.med.domain.model;

import gov.va.med.domain.typecode.ContactMethodTypeCode;

import java.io.Serializable;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;


/** 
 *        @hibernate.class
 *         table="CONTACT_INFORMATIONS"
 *     
*/
public class ContactInformation extends DomainObject implements Serializable {

    /** persistent field */
    private ContactMethodTypeCode contactMethod;

    /** nullable persistent field */
    private String phoneNumber;

    /** nullable persistent field */
    private String extension;

    /** nullable persistent field */
    private String emailAddress;

    /** nullable persistent field */
    private Long adminuserId;
    
    /** nullable persistent field */
    private Long userId;

    /** full constructor */
    public ContactInformation(ContactMethodTypeCode contactMethod, String phoneNumber, String extension, String emailAddress, Long adminuserId) {
        this.contactMethod = contactMethod;
        this.phoneNumber = phoneNumber;
        this.extension = extension;
        this.emailAddress = emailAddress;
        this.adminuserId = adminuserId;
        this.userId = adminuserId;
    }

    /** default constructor */
    public ContactInformation() {
    }

    /** minimal constructor */
    public ContactInformation(ContactMethodTypeCode contactMethod) {
        this.contactMethod = contactMethod;
    }


    /** 
     *            @hibernate.property
     *             column="CONTACT_METHOD"
     *             length="2"
     *             not-null="true"
     *         
     */
    public ContactMethodTypeCode getContactMethod() {
        return this.contactMethod;
    }

    public void setContactMethod(ContactMethodTypeCode contactMethod) {
        this.contactMethod = contactMethod;
    }

    /** 
     *            @hibernate.property
     *             column="PHONE_NUMBER"
     *             length="20"
     *         
     */
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    /** 
     *            @hibernate.property
     *             column="EXTENSION"
     *             length="8"
     *         
     */
    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    /** 
     *            @hibernate.property
     *             column="EMAIL_ADDRESS"
     *             length="50"
     *         
     */
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    /** 
     *            @hibernate.property
     *             column="ADMIN_USER_ID_SEQ"
     *             length="22"
     *         
     */
    public Long getAdminuserId() {
        return this.adminuserId;
    }

    public void setAdminuserId(Long adminuserId) {
        this.adminuserId = adminuserId;
    }
    
    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String toString() {
        return new ToStringBuilder(this)
            .append("Id", getId())
			.append("adminuserId", getAdminuserId())
			.append("contactMethod", getContactMethod())
			.append("phoneNumber", getPhoneNumber())
			.append("extension", getExtension())
			.append("emailAddress", getEmailAddress())
            .toString();
    }
    
    public boolean equals(Object other) {
        if ( (this == other ) ) return true;
        if ( !(other instanceof ContactInformation) ) return false;
        ContactInformation castOther = (ContactInformation) other;
        return new EqualsBuilder()
            .append(this.getId(), castOther.getId())
			.append(this.getAdminuserId(), castOther.getAdminuserId())
            .append(this.getContactMethod(), castOther.getContactMethod())
            .append(this.getVersionNumber(), castOther.getVersionNumber())
            .isEquals();
    }

}
